﻿// Initialization of the text boxes
$(document).ready(function () {
    var KEY_SHIFT = 16;
    var KEY_TAB = 9;
    var KEY_LEFT = 37;
    var KEY_UP = 38;
    var KEY_RIGHT = 39;
    var KEY_DOWN = 40;

    $('textarea[maxlength]').on("keypress", function (e) {
        var maxLength = parseInt($(this).attr('maxlength'));
        var length = $(this).val().length;
        return length < maxLength || e.keyCode == 46 || e.keyCode == 8;
    });

    $(".editBox, .textArea").not(".openEnd").on("keyup change", function (e) {
        var keyArr = [KEY_SHIFT, KEY_TAB, KEY_LEFT, KEY_UP, KEY_RIGHT, KEY_DOWN];

        if (keyArr.includes(e.keyCode)) {
            return;
        }

        var container = $(this).closest(".questionBackground");
        var choices = $("[name=C-" + $(this).attr("name") + "]", container);
        choices.prop("checked", false);
        if (typeof defaultRadioImage != "undefined" && defaultRadioImage) {
            choices.each(function () {
                $(this).siblings(".radioImage").attr("src", defaultRadioImage);
            });
        }
        if (isInGrid($(this))) {
            toggleGridOpenEnds($(this));
        }
    });

    if (typeof defaultRadioImage != "undefined" && defaultRadioImage) {
        $(".radioButton .choice").on("click", function () {
            ClearTextBox($(this).find(":radio"));
        });
    }
    else {
        $(".radioButton .choice :radio").on("click", function () {
            ClearTextBox($(this));
        });
    }

    if ($.fn.autoNumeric) {
        $(".runningTotal input.numericAnswer:not(.rankingItem)").autoNumeric({ "vMax": 9223372036854775808.99, "vMin": 0 });
        $("input.numericAnswer:not(.rankingItem)").autoNumeric({ "vMax": 9223372036854775808.99, "vMin": -9223372036854775808.99 });
    }
});

function ClearTextBox(radioButton) {
    var container = radioButton.closest(".questionBackground");
    var editBox = $("[name=" + radioButton.attr("name").substring(2) + "]", container);
    editBox.val("");
}